<?php
// 1. Inclui o menu e conecta
require_once("menu.php");

if (file_exists('api/controles/db.php')) {
    require_once('api/controles/db.php');
} else {
    die("Erro Crítico: Arquivo 'api/controles/db.php' não encontrado.");
}

$pdo = conectar_bd();

// --- CONTAGENS DO BANCO DE DADOS ---
$total_canais = $pdo->query("SELECT COUNT(*) FROM streams WHERE stream_type = 'live'")->fetchColumn();
$total_filmes = $pdo->query("SELECT COUNT(*) FROM streams WHERE stream_type = 'movie'")->fetchColumn();
// Contagem de SÉRIES (A capa/título da série)
$total_series_real = $pdo->query("SELECT COUNT(*) FROM series")->fetchColumn();
// Contagem de EPISÓDIOS (Os arquivos de vídeo)
$total_episodios = $pdo->query("SELECT COUNT(*) FROM series_episodes")->fetchColumn();
?>

<style>
    /* ================================================================== */
    /* ### ESTILOS DOS CARDS ### */
    /* ================================================================== */
    .stat-card {
        border: none;
        border-left-width: 5px;
        border-left-style: solid;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        transition: transform 0.2s ease, box-shadow 0.2s ease;
        border-radius: 8px; 
        background-color: var(--bs-card-bg);
    }
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
    }
    .stat-card .card-body {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 1.5rem; 
    }
    .stat-info .stat-label {
        font-size: 0.85rem; /* Levemente menor para caber melhor */
        color: #adb5bd; 
        text-transform: uppercase;
        font-weight: 700;
    }
    .stat-info .stat-value {
        font-size: 2rem;
        font-weight: 700;
        margin: 0;
        color: var(--bs-heading-color);
    }
    .stat-icon {
        font-size: 3rem;
        opacity: 0.15;
    }

    /* Cores Específicas */
    .stat-card.card-tv { border-color: #fd7e14; } /* Laranja */
    .stat-card.card-tv .stat-label, .stat-card.card-tv .stat-icon { color: #fd7e14; }

    .stat-card.card-filmes { border-color: #20c997; } /* Verde Água */
    .stat-card.card-filmes .stat-label, .stat-card.card-filmes .stat-icon { color: #20c997; }
    
    /* NOVA COR PARA SÉRIES (Rosa/Magenta) */
    .stat-card.card-series { border-color: #d63384; } 
    .stat-card.card-series .stat-label, .stat-card.card-series .stat-icon { color: #d63384; }

    .stat-card.card-episodios { border-color: #6f42c1; } /* Roxo */
    .stat-card.card-episodios .stat-label, .stat-card.card-episodios .stat-icon { color: #6f42c1; }

    /* Outros Estilos */
    .preview-item {
        border: 1px solid var(--bs-border-color);
        border-radius: 0.375rem;
        padding: 0.75rem;
        margin-bottom: 0.5rem;
        background-color: var(--bs-tertiary-bg);
    }
    .preview-old { color: #dc3545; text-decoration: line-through; font-size: 0.85rem; word-break: break-all; }
    .preview-new { color: #198754; font-weight: bold; font-size: 0.85rem; word-break: break-all; }
    
    .loading-overlay {
        position: fixed; top: 0; left: 0; width: 100%; height: 100%;
        background: rgba(0,0,0,0.8); display: flex; justify-content: center; align-items: center;
        z-index: 9999; display: none; flex-direction: column; color: white;
    }
    
    /* Ajustes Tema Escuro */
    body.dark-mode .form-control, body.dark-mode .form-select {
        background-color: #2a2a2a; border-color: #444; color: #fff;
    }
    body.dark-mode .form-text { color: #aaa; }
</style>

<div class="loading-overlay" id="loadingOverlay">
    <div class="spinner-border text-primary mb-3" role="status" style="width: 3rem; height: 3rem;"></div>
    <h5 class="mb-0">Processando... Por favor, aguarde.</h5>
</div>

<div class="container-fluid p-md-4 p-2">

    <div class="page-header mb-4">
        <h1 class="h3 mb-0"><i class="bi bi-arrow-left-right me-2"></i>Alteração em Massa - Links</h1>
        <p class="text-muted">Substitua domínios ou partes de URLs em todo o seu conteúdo.</p>
    </div>

    <div class="row mb-4">
        <div class="col-sm-6 col-xl-3 mb-3">
            <div class="card stat-card card-tv h-100">
                <div class="card-body">
                    <div class="stat-info"><div class="stat-label">Canais</div><p class="stat-value"><?= $total_canais ?></p></div>
                    <div class="stat-icon"><i class="fa-solid fa-tv"></i></div>
                </div>
            </div>
        </div>
        
        <div class="col-sm-6 col-xl-3 mb-3">
            <div class="card stat-card card-filmes h-100">
                <div class="card-body">
                    <div class="stat-info"><div class="stat-label">Filmes</div><p class="stat-value"><?= $total_filmes ?></p></div>
                    <div class="stat-icon"><i class="fa-solid fa-film"></i></div>
                </div>
            </div>
        </div>
        
        <div class="col-sm-6 col-xl-3 mb-3">
            <div class="card stat-card card-series h-100">
                <div class="card-body">
                    <div class="stat-info"><div class="stat-label">Séries</div><p class="stat-value"><?= $total_series_real ?></p></div>
                    <div class="stat-icon"><i class="fa-solid fa-clapperboard"></i></div>
                </div>
            </div>
        </div>

        <div class="col-sm-6 col-xl-3 mb-3">
            <div class="card stat-card card-episodios h-100">
                <div class="card-body">
                    <div class="stat-info"><div class="stat-label">Episódios</div><p class="stat-value"><?= $total_episodios ?></p></div>
                    <div class="stat-icon"><i class="fa-solid fa-photo-film"></i></div>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-gear-fill me-2"></i>Configurar Substituição</h5>
        </div>

        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label fw-bold">Buscar por (Texto Antigo):</label>
                    <input type="text" class="form-control form-control-lg" id="searchFrom" placeholder="Ex: http://servidor-antigo.com">
                    <div class="form-text">O trecho do link que você quer remover.</div>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-bold">Substituir por (Texto Novo):</label>
                    <input type="text" class="form-control form-control-lg" id="replaceWith" placeholder="Ex: http://novo-dns.com">
                    <div class="form-text">O novo texto que entrará no lugar.</div>
                </div>
            </div>

            <div class="row g-3 mt-4 p-3 border rounded bg-opacity-10 bg-secondary">
                <div class="col-12"><label class="form-label fw-bold mb-2">Aplicar em:</label></div>
                <div class="col-md-4">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="tableCanais" checked>
                        <label class="form-check-label" for="tableCanais">Canais de TV</label>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="tableFilmes" checked>
                        <label class="form-check-label" for="tableFilmes">Filmes (VOD)</label>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="tableSeries" checked>
                        <label class="form-check-label" for="tableSeries">Séries (Episódios)</label>
                    </div>
                </div>
            </div>

            <div class="row g-3 mt-4">
                <div class="col-md-6">
                    <button class="btn btn-outline-info w-100" onclick="previewChanges()">
                        <i class="bi bi-search me-2"></i>Simular (Prévia)
                    </button>
                </div>
                <div class="col-md-6">
                    <button class="btn btn-success w-100" onclick="executeChanges()" id="btnExecute" disabled>
                        <i class="bi bi-check-circle me-2"></i>Executar Troca
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div id="previewResults" style="display: none;" class="mt-4">
        <div class="card border-info shadow-sm">
            <div class="card-header bg-info text-white">
                <h6 class="mb-0"><i class="bi bi-eye me-2"></i>Resultado da Simulação</h6>
            </div>
            <div class="card-body">
                <div class="alert alert-light border d-flex justify-content-between align-items-center">
                    <span>Total de itens encontrados para alterar:</span>
                    <span id="previewCount" class="badge bg-primary fs-5">0</span>
                </div>
                <h6 class="fw-bold mb-3">Exemplos do que vai acontecer:</h6>
                <div id="previewContent"></div>
                <div class="alert alert-warning mt-3 mb-0 border-warning">
                    <i class="bi bi-exclamation-triangle-fill me-2"></i> 
                    <strong>Atenção:</strong> Verifique se os exemplos acima estão corretos antes de clicar em "Executar Troca".
                </div>
            </div>
        </div>
    </div>

</div>

<?php require_once("footer.php"); ?>

<script>
function showLoading(show) {
    document.getElementById('loadingOverlay').style.display = show ? 'flex' : 'none';
}

async function previewChanges() {
    const search = document.getElementById('searchFrom').value.trim();
    const replace = document.getElementById('replaceWith').value.trim();
    
    if(!search) return Swal.fire('Atenção', 'Digite o texto que deseja buscar/remover.', 'warning');
    
    let tables = [];
    if(document.getElementById('tableCanais').checked) tables.push('canais');
    if(document.getElementById('tableFilmes').checked) tables.push('filmes');
    if(document.getElementById('tableSeries').checked) tables.push('series');
    
    if(tables.length === 0) return Swal.fire('Atenção', 'Selecione pelo menos uma opção.', 'warning');

    showLoading(true);

    const formData = new FormData();
    formData.append('action', 'preview');
    formData.append('search_from', search);
    formData.append('replace_with', replace);
    formData.append('tables', JSON.stringify(tables));

    try {
        const req = await fetch('api/api_mass_link_update.php', { method: 'POST', body: formData });
        const res = await req.json();

        if(res.success) {
            document.getElementById('previewCount').innerText = res.total_items;
            
            let html = '';
            if(res.examples.length > 0) {
                res.examples.forEach(ex => {
                    html += `
                    <div class="preview-item">
                        <div class="fw-bold mb-1 text-primary">${ex.name}</div>
                        <div class="preview-old"><i class="bi bi-x-circle me-1"></i> ${ex.old_url}</div>
                        <div class="preview-new"><i class="bi bi-check-circle me-1"></i> ${ex.new_url}</div>
                    </div>`;
                });
            } else {
                html = '<p class="text-muted text-center py-3">Nenhum link encontrado com esse termo.</p>';
            }
            
            document.getElementById('previewContent').innerHTML = html;
            document.getElementById('previewResults').style.display = 'block';
            
            document.getElementById('btnExecute').disabled = (res.total_items == 0);
            
            document.getElementById('previewResults').scrollIntoView({ behavior: 'smooth' });
        } else {
            Swal.fire('Erro', res.message, 'error');
        }
    } catch(e) {
        Swal.fire('Erro', 'Falha na conexão com a API.', 'error');
    } finally {
        showLoading(false);
    }
}

async function executeChanges() {
    const count = document.getElementById('previewCount').innerText;
    
    const result = await Swal.fire({
        title: 'Confirmar Alteração?',
        html: `Você vai alterar <b>${count} links</b>.<br>Essa ação não pode ser desfeita!`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#198754',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sim, alterar!',
        cancelButtonText: 'Cancelar'
    });

    if (result.isConfirmed) {
        showLoading(true);
        
        const search = document.getElementById('searchFrom').value.trim();
        const replace = document.getElementById('replaceWith').value.trim();
        let tables = [];
        if(document.getElementById('tableCanais').checked) tables.push('canais');
        if(document.getElementById('tableFilmes').checked) tables.push('filmes');
        if(document.getElementById('tableSeries').checked) tables.push('series');

        const formData = new FormData();
        formData.append('action', 'execute');
        formData.append('search_from', search);
        formData.append('replace_with', replace);
        formData.append('tables', JSON.stringify(tables));

        try {
            const req = await fetch('api/api_mass_link_update.php', { method: 'POST', body: formData });
            const res = await req.json();
            
            if(res.success) {
                await Swal.fire('Sucesso!', `Foram atualizados ${res.main_links_updated} links.`, 'success');
                location.reload();
            } else {
                Swal.fire('Erro', res.message, 'error');
            }
        } catch(e) {
             Swal.fire('Erro', 'Falha na conexão.', 'error');
        } finally {
            showLoading(false);
        }
    }
}
</script>